/* -*- mode: C; comment-column: 40; fill-column: 79 -*- */
/* $Id: global.h,v 1.39 1999/01/20 03:04:02 ericb Exp $ */
/* Copyright (C) 1994 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Taken from E1431 library, heavily modified by Eric Backus */

/* This is the header file for the global data for the E1432 library.

   A set of flags (NOEXTERN_FLAG, GLOBAL) is used so that storage is allocated
   in only one file (#ifdef NOEXTERN_FLAG) and not in the others (#ifndef
   NOEXTERN_FLAG).  The file where global data is allocated is modgroup.c.

   The E1432 library is compiled into many different target files:

   File		OS	Hw	I/O	Used by
   -------------------------------------------------------------
   lib1432.a	HP-UX	s700	SICL	Potentially by end users
   lib1432.sl	HP-UX	s700	SICL	End users
   lib1432.pio	HP-UX	s700	SICL	LMS Engine
   hpe1432.sl	HP-UX	s700	VISA	End users
   libd1432.a	SPOS	E1485	SICL	MBBM
   E1432.DU?	?	E1406	?	Diagnostics
   E1432.DLL?	WinNT	i386	VISA	End users
   E1432.DLL?	Win3.1?	i386	ESICL	Production?

   Of these, the E1406 build is a special case.  It is done in a separate
   directory (../diagnostics).  Its source files include exec_rtn.h, which
   includes global.h.  In this case, global.h must include the rest of the
   semaphore-specific include files. */

#ifdef HPVXI_DOWNLOAD
/* sema.h includes global.h in the correct place */
#ifndef _E1432_SEMA_H  /* In sema.h but cc68000 seems to need this */
#include "sema.h"
#endif /* _E1432_SEMA_H */
#endif

#ifndef _E1432_GLOBAL_H
#define _E1432_GLOBAL_H

#ifdef HPVXI_DOWNLOAD
#pragma SECTION DATA=DATA_SECTION
extern INSTRUMENT_STATE_STRUCT E1432A;
#define NULL 0
#define HPVXI_DOWNLOAD_DEBUG
#endif

#ifdef HPVXI_DOWNLOAD_DEBUG
#define DBPF(_m, _p)            \
  {                             \
    char _m[200];               \
    sprintf _p;                 \
    os_display_message(5, _m);  \
    os_pause_p(10);             \
  }
#else /* HPVXI_DOWNLOAD_DEBUG */
#define DBPF(_m, _p)		/* don't do except in HPVXI_DOWNLOAD_DEBUG */
#endif /* HPVXI_DOWNLOAD_DEBUG */

#ifdef	NOEXTERN_FLAG
#define GLOBAL
#else
#define GLOBAL extern
#endif

#define E1432_MOD_OPT_LIST_MAX	100

/* Put instrument global data declarations here: */
#ifdef	HAVE_SIGBUS
GLOBAL jmp_buf i1432_buserr_env;
GLOBAL volatile int i1432_buserr_env_valid;
GLOBAL int i1432_buserr_trap;
#endif
#if defined(HAVE_SICL) || defined(HAVE_VTL)
GLOBAL char i1432_sicl_name[E1432_SICL_NAME_MAX]; /* SICL interface name */
GLOBAL INST i1432_sicl_id;		/* Instrument identifier */
GLOBAL SHORTSIZ16 *i1432_a16_base;    	/* Base of A16 address space */
#endif
#ifdef	HAVE_SICL
GLOBAL struct i1432_iopen_list_info i1432_iopen_list_info;
GLOBAL int i1432_a16_id_index;		/* Index for a16 base imap */
GLOBAL int i1432_have_a24_d32;		/* Does SICL accept A24_D32 */
GLOBAL int i1432_sicl_imap_count;	/* How many imaps open */
GLOBAL int i1432_sicl_imap_max;		/* Max maps to keep open */
#endif
GLOBAL int i1432_lib_init;		/* Library initialized */
GLOBAL E1432_MODULE_LIST_NODE *i1432_mod_list; /* Module list */
GLOBAL int i1432_mod_count;		/* Entries in module list */
GLOBAL struct i1432_chan_info *i1432_chan_list[E1432_CHAN_TYPES];
GLOBAL int i1432_chan_count[E1432_CHAN_TYPES]; /* Entries in channel list */
GLOBAL E1432_GROUP_LIST_NODE *i1432_group_list; /* Head of group list */
GLOBAL int i1432_trace_level;		/* Set by e1432_trace_level */
GLOBAL int i1432_print_reg_access;	/* Set by e1432_debug_level */
GLOBAL int i1432_print_errors;		/* Set by e1432_print_errors */
GLOBAL char *i1432_error_str;		/* Error string pointer */
GLOBAL char *i1432_error_info;		/* Extra error string pointer */
GLOBAL SHORTSIZ16 i1432_dnld_fw_err;    /* substrate FW download error */
GLOBAL LONGSIZ32 i1432_dnld_fw_state;   /* state of substrate FW download */
GLOBAL const char *i1432_install_file;	/* File to do install from */
GLOBAL SHORTSIZ16 i1432_install_from_mem; /* Do install from C array */
GLOBAL SHORTSIZ16 i1432_diag_print_level; /* for DIAG_PRINTF() */
GLOBAL int i1432_trigger_sent;		/* Used by e1432_send_trigger */
GLOBAL int i1432_kludge_data_rpm_flag;	/* For master triggering */
GLOBAL SHORTSIZ16 i1432_kludge_data_rpm_id1; /* For master triggering */
GLOBAL FLOATSIZ32 i1432_kludge_data_rpm1; /* For master triggering */
GLOBAL FLOATSIZ32 i1432_kludge_data_rpm2; /* For master triggering */
GLOBAL int i1432_kludge_enable_flag;	/* For enable_none block available */
GLOBAL int i1432_kludge_tach_flag;	/* For slave triggering */
GLOBAL int i1432_rs_irq_error;		/* Error handling request interrupts */
#ifdef	HAVE_VTL
GLOBAL int i1432_visa_d16;		/* Use 16-bit transfers in VISA */
GLOBAL int i1432_visa_introff_count;	/* Nesting level of VISA introff */
GLOBAL int i1432_visa_lock_mode;
#endif

/*  HW config info for diagnostics */
GLOBAL char i1432_mod_opt_list[E1432_MOD_OPT_LIST_MAX+1];
GLOBAL E1432_DIAG_CONFIG i1432_diag_config;

#ifdef	HPVXI_DOWNLOAD
GLOBAL volatile char ocas_flag;
GLOBAL volatile char device_clear_flag;
GLOBAL char *i1432_output_buffer;
GLOBAL int formatscaling;		/* ENUM_ON or ENUM_OFF */
GLOBAL int formattype;			/* ENUM_ASC or ENUM_PACK */
GLOBAL int nextchanread;		/* next channel for DATA:DATA? */
GLOBAL SHORTSIZ16 i1432_la;		/* logical address of this module */
#endif

#ifdef HPVXI_DOWNLOAD
#pragma SECTION UNDO
#endif

#endif /* _E1432_GLOBAL_H */
